package logica;
import java.io.*;
import java.util.Arrays;
import java.util.Vector;

import org.pgusb.usbDllAdapter.UsbDllAdapter;

import boot.BootLoader;

import exceptions.ParseHexRecordException;


public class rfile {
	static final String vid_pid= "vid_04d8&pid_000b";
	
	private HexFile hf;
	
	public void readHexFile(String filename){
		try {
		/*
		 * Sets up a file reader to read the file passed on the
		 * command line one character at a time
		 */
		FileReader input = new FileReader(filename);
		
		/*
		 * Filter FileReader through a Buffered read to read a line
		 * at a time
		 */
		BufferedReader bufRead = new BufferedReader(input);
		
		String line;    // String that holds current file line
		int count = 0;  // Line number of count
		
		// Read first line
		boolean termine = false;
		count++;
		// Read through file one line at time. Print line #
		// and line
		hf = new HexFile();
		int ulba = 0;
		while (!termine){
			line = bufRead.readLine();
			if (line!=null){
				System.out.println(count+": "+line);
				//proceso la linea
				HexRecord hr = new HexRecord(32);
				try {
					hr.parse(line);
					if (hr.getRectype()==HexRecord.EXTENDED_LINEAR_ADDRESS_RECORD) {
						ulba = hr.getOffset();
					}
					if (hr.getRectype()==HexRecord.DATA_RECORD){
						hr.setLinearAddress(hr.getOffset()+ulba);
					}
					hf.addRecord(hr);
				} catch (ParseHexRecordException e){
					e.printStackTrace();
				}
				
				
				count++;
			}
			else termine=true;
		}
		
		bufRead.close();
		
//		 TODO Auto-generated method stub
		int res = 255;
		try {
			res = UsbDllAdapter.MPUSBGetDLLVersion();
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		System.out.println("Version de la dll: " + res/65536 + "." + res%65536 );
		try {
			res = UsbDllAdapter.MPUSBGetDeviceCount(vid_pid);
		} catch (Exception e){
			System.out.println(e.getMessage());
		}
		System.out.println("Cantidad de dispositivos conectados: " +res );
		
		BootLoader bl = new BootLoader();
		bl.init(0);
		bl.open();
		/*
		Vector<HexRecord> lhr = hf.getHexList();
		for (int i=0 ; i<lhr.size() ; i++){
			HexRecord hrr = lhr.elementAt(i);
			if (hrr.getRectype()==hrr.DATA_RECORD){
				System.out.println("offset: "+ hrr.getOffset() + " reclen: " + hrr.getRecLen());
				byte[] readBytes =  bl.readFlash(hrr.getLinearAddress(),hrr.getRecLen());
				if (Arrays.equals(hrr.getBinData(),readBytes)){
					System.out.println("coinciden");
				}
				else {
					System.out.println("NO coinciden");
				}
			}
		}
		*/
		/*
		for (int i=0x82a ; i<0x8000 ; i+=16){
			bl.readFlash(i,16);
		}
		*/
		bl.close();
		System.out.println("termino");
	}catch (IOException e){
		// If another exception is generated, print a stack
		// trace
		e.printStackTrace();
	}
	}
	
	public void printDataArray(byte[] data){
		byte[] c=data;
		//System.out.println("en binario: ");
		for (int i=0;i<c.length;i++){
			String s = Integer.toHexString(Byte.valueOf(c[i]));
			if (s.length()>1) s = s.substring(s.length()-2);
			else s = "0"+s;
			System.out.print(s +" ");
		}
		System.out.println();
	}
	
	public Vector<DataHexRecord> getRecords(int startAddress,int endAddress){
		return hf.getRecords(startAddress,endAddress);
		
	}
	
	
}
